<?PHP 
	$this->load->view('api/header'); 
	$this->load->view('api/nav'); 
	$this->load->helper('form');
?>
				<h1>Reports</h1>
				<div class = "column">
					<div id="tabs" class="column ui-tabs ui-widget ui-widget-content ui-corner-all">
						<ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
							<li class="reports-tab ui-state-default ui-corner-top ui-tabs-selected ui-state-active"><a href="/reports/requests">Requests</a></li>
							<li class="reports-tab ui-state-default ui-corner-top"><a href="/reports/events">Events</a></li>
							<li class="reports-tab ui-state-default ui-corner-top"><a href="/reports/logins">Logins</a></li>
							<li class="reports-tab ui-state-default ui-corner-top"><a href="/reports/mail">Mail</a></li>
							<li class="reports-tab ui-state-default ui-corner-top"><a href="/reports/tickets">Tickets</a></li>
						</ul>
					<div class="tab-content">
						<p>This table lists the requests.</p>
						<?PHP echo form_open('/reports/requests',array('id'=>'reports_form','onsubmit'=>"javascript:submitPaginationForm('', this.value, ".$form_data['items_per_page'].", '');")); ?>
							<table class="form">
								<tr class="form_row">
									<td>Application:</td>
									<td>
										<select class="fill_row" id="whichapp" name="whichapp" onkeydown="if(event.keyCode == 13){this.form.submit();return false;}">
											<option value="(ALL)">(ALL)</option>
											<?php foreach($apps as $app){ ?>
											<option value="<?php echo $app->id;?>" <?php if (isset($form_data['whichapp']) && $app->id==$form_data['whichapp']){echo "selected";}?>><?php echo $app->name;?></option>
											<?php  } ?>
										</select>
									</td>
								</tr>	
								<tr class="form_row">
									<td>ID:</td>
									<td>
										<p class="hidden_context">Help Text for ID: Table ID of request</p>
										<input class="ttFocus" title="Table ID of request" id="request_id" name="request_id" type="text" value="<?php if(isset($form_data['request_id'])) { echo $form_data['request_id']; } ?>" onkeydown="if(event.keyCode == 13){$('#request_id').onfocus = function(){this.form.submit();return false;}}"></input>
									</td>
									<td>
										<label class="hidden_context">Compare options for ID</label>
										<select id="request_id_type" name="request_id_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if (isset($form_data['request_id_type']) && $key == $form_data['request_id_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>
									
									<td>Call:</td>
									<td>
										<p class="hidden_context">Help Text for Call: The API service being called by the application</p>
										<input class="ttFocus" title="The API service being called by the application" id="request_call" name="request_call" type="text" value="<?php if(isset($form_data['request_call'])) { echo $form_data['request_call']; } ?>" onkeydown="if(event.keyCode == 13){$('#request_call').onfocus = function(){this.form.submit();return false;}}"></input>								
									</td>
									<td>
										<label class="hidden_context">Compare options for Call</label>
										<select id="request_call_type" name="request_call_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if (isset($form_data['request_call_type']) && $key == $form_data['request_call_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>
								</tr>								
								<tr class = "form_row">
									<td>Response Code:</td>
									<td>
										<p class="hidden_context">Help Text for Response Code: HTTP response code that denotes the success or error of the request</p>
										<input class="ttFocus" title="HTTP response code that denotes the success or error of the request" id = "request_code" name = "request_code" type = "text" value = "<?php if(isset($form_data['request_code'])) { echo $form_data['request_code']; } ?>" onkeydown = "if(event.keyCode == 13){$('#request_code').onfocus = function(){this.form.submit();return false;}}"></input>
									</td>
									<td>
										<label class="hidden_context">Compare options for Response Code</label>
										<select id="request_code_type" name="request_code_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if (isset($form_data['request_code_type']) && $key==$form_data['request_code_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>									
									<td>Response:</td>
									<td>
										<p class="hidden_context">Help Text for Response: The JSON response from the API</p>
										<input class="ttFocus" title="The JSON response from the API" id="request_response" name="request_response" type="text" value="<?php if(isset($form_data['request_response'])) { echo $form_data['request_response']; } ?>" onkeydown="if(event.keyCode == 13){$('#request_response').onfocus = function(){this.form.submit();return false;}}"></input>
									</td>
									<td>
										<label class="hidden_context">Compare options for Response</label>
										<select id="request_response_type" name="request_response_type">
											<?php foreach($compare as $key => $value){ ?>
											<option value="<?php echo $key;?>" <?php if (isset($form_data['request_response_type']) && $key == $form_data['request_response_type']){echo "selected";}?>><?php echo $value?></option>
											<?php  } ?>
										</select>
									</td>
								</tr>								
								<tr class="form_row">
									<td>Start Date:</td>
									<td><input type="text" id="start_date" name="start_date" class="date" value="<?php if(isset($form_data['start_date'])) { echo $form_data['start_date']; } ?>" onkeydown="if(event.keyCode == 13){$('#start_date').onfocus=function(){this.form.submit();return false;}}"/></td>
									<td>&nbsp;</td>
									<td>End Date:</td>
									<td><input type="text" id="end_date" name="end_date" class="date" value="<?php if(isset($form_data['end_date'])) { echo $form_data['end_date']; } ?>" onkeydown="if(event.keyCode == 13){$('#end_date').onfocus = function(){this.form.submit();return false;}}"/></td>
								</tr>
								<script>$('input.date').datetimepicker({timeFormat: "hh:mm tt"});</script>
							</table>
							<?PHP
								$hidden_inputs = array(
									'order' => isset($form_data['order']) ? $form_data['order'] : '',
									'direction' => isset($form_data['direction']) ? $form_data['direction'] : '',
									'lastorder' => isset($form_data['order']) ? $form_data['order']  : '',
									'change' => 'false',
									'export' => '0',
									'page_on_bar' => '',
									'items_per_page' => ITEMS_PER_PAGE_DEFAULT,
								);
								echo form_hidden($hidden_inputs,TRUE);
							?>
							<div class="center">
								<input class="blue-button" id="filter_button" name="filter_button" type="submit" value="Filter"></input>
								<input class="blue-button" id="clear_button" name="clear_button" type="button" value="Clear" onclick="$('#clear_form').submit();"></input>
							</div>
							
							<?php if (sizeof($request_list) != 0) { ?>
								<div class="pagination">
									<?php echo $form_data['pages']->display_result_num();?>
									<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php echo $form_data['pages']->display_pages();?></span>
									<?php echo $form_data['pages']->display_items_per_page();?>
									<div style="float:right; position: relative;">
										<img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" onclick ="$('#export').attr('value','1');$('#reports_form').submit();$('#export').attr('value','0');" />
										<label class="hidden_context">Page Selector</label>
										<select id="page_select" name="page_select" onchange="javascript:submitPaginationForm('', this.value, <?php echo $form_data['items_per_page'];?>, '');">
											<?php for($count = 1;$count <= $form_data['num_pages'];$count++){ ?>
											<option value="<?php echo $count;?>" <?php if ($count == $form_data['cur_page']){echo "selected";}?>><?php echo $count;?></option>
											<?php  } ?>
										</select>
										<span class="paginate"> of <?php echo $form_data['num_pages'];?></span>
									</div>
								</div>
							<?php  } ?>
						<?PHP echo form_close(); ?>
						<?PHP echo form_open('/reports/requests',array('id'=>'clear_form')); echo form_close(); ?>
						<?php if (sizeof($request_list) == 0) { ?>
							<div class="message">There are currently no web service requests.</div>
						<?php }else{ ?>
							<table class="display">	
								<tr class="report_row">
									<th width="5%"><a href='#' style="color:#FFFFFF;" onclick="$('#order').attr('value','id');$('#change').attr('value','true');$('#reports_form').submit();">ID<?php  if(isset($form_data['order'])&&$form_data['order'] == 'id'){echo $image;} ?></a></th>
									<th width="12%"><a href='#' style="color:#FFFFFF;" onclick="$('#order').attr('value','application_id');$('#change').attr('value','true');$('#reports_form').submit();">Application<?php  if(isset($form_data['order'])&&$form_data['order'] == 'application_id'){ echo $image; } ?></a></th>
									<th width="20%"><a href='#' style="color:#FFFFFF;" onclick="$('#order').attr('value','call');$('#change').attr('value','true');$('#reports_form').submit();">Call<?php  if(isset($form_data['order'])&&$form_data['order'] == 'call'){ echo $image; } ?></a></th>
									<th width="11%"><a href='#' style="color:#FFFFFF;" onclick="$('#order').attr('value','call_date');$('#change').attr('value','true');$('#reports_form').submit();">Date (<?php echo $timezone_abbr; ?>)<?php  if(isset($form_data['order'])&&$form_data['order'] == 'call_date'){ echo $image; } ?></a></th>
									<th width="5%"><a href='#' style="color:#FFFFFF;" onclick="$('#order').attr('value','response_code');$('#change').attr('value','true');$('#reports_form').submit();">Response Code<?php  if(isset($form_data['order'])&&$form_data['order'] == 'response_code'){echo $image; } ?></a></th>
									<th width="35%" class="displaylast"><a href='#' style="color:#FFFFFF;" onclick="$('#order').attr('value','response');$('#change').attr('value','true');$('#reports_form').submit();">Response<?php  if(isset($form_data['order'])&&$form_data['order'] == 'response'){ echo $image; } ?></a></th>
								</tr>
								<?php foreach($request_list as $request){ ?>
									<tr class="report_row">
										<td class="break-word"><?php echo $request->id; ?></td>
										<td class="break-word"><?php echo $request->application_id; ?></td>
										<td class="break-word"><?php echo $request->call; ?></td>
										<td class="break-word" ><?php echo $request->call_date; ?></td>
										<td class="break-word" ><?php echo $request->response_code; ?></td>
										<td class="break-word " ><?php echo $request->response; ?></td>
									</tr>
								<?php  } ?>
							</table>
							
							<div class="pagination">
								<?php echo $form_data['pages']->display_result_num();?>
								<span>&nbsp;&nbsp;&nbsp;&nbsp;<?php echo $form_data['pages']->display_pages();?></span>
								<?php echo $form_data['pages']->display_items_per_page();?>
								<div style="float:right; position: relative;">
									<img src="/images/icons/page_white_excel.png" class="link" style="border : 0;" alt="Export Excel" onclick="$('#export').attr('value','1');$('#reports_form').submit();$('#export').attr('value','0');" />
									<label class="hidden_context">Page Selector</label>
									<select id="page_select" name="page_select" onchange="javascript:submitPaginationForm('', this.value, <?php echo $form_data['items_per_page'];?>, '');" >
										<?php for($count = 1;$count <= $form_data['num_pages'];$count++){ ?>
										<option value="<?php echo $count;?>" <?php if ($count == $form_data['cur_page']){echo "selected";}?>><?php echo $count;?></option>
										<?php  } ?>
									</select>
									<span class="paginate"> of <?php echo $form_data['num_pages'];?></span>
								</div>
							</div>
							
							<?php } ?>
						</div>
					</div>
				</div>
			</div>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>